﻿using System;
using VA.TMP.Integration.VIMT.HealthShare.StateObject;
using VA.TMP.Integration.VIMT.Messages.HealthShare;
using VA.TMP.Integration.VIMT.Shared;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.HealthShare.PipelineSteps.MakeCancelInbound
{
    /// <summary>
    /// Get Outbound Request Message step.
    /// </summary>
    public class GetOutboundRequestMessageStep : FilterBase<MakeCancelInboundStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(MakeCancelInboundStateObject state)
        {
            try
            {
                var integrationRequest = state.IntegrationResult.mcs_integrationrequest;
                if (string.IsNullOrEmpty(integrationRequest)) throw new Exception($"The Integration Request cannot be null or empty for Integration Result {state.IntegrationResult.Id}");

                state.OutboundRequestMessage = PipelineUtilities.Deserialize<TmpHealthShareMakeCancelOutboundRequestMessage>(integrationRequest);
            }
            catch (Exception ex)
            {
                Logger.Instance.Error($"ERROR: HealthShare Make Cancel Inbound Get Outbound Request Message Pipeline Error: {ex.Message}", ex.InnerException);
                throw new Exception($"HealthShare Make Cancel Inbound Get Outbound Request Message Pipeline Error: {ex.Message}", ex.InnerException);
            }
        }
    }
}